
kUnknownID = -1;

//-----------------------------------------------------------------------------
// zSequenceMap - encapsulates the sequence of dialogs using transition maps
//		associated with each dialog.
//-----------------------------------------------------------------------------
function zSequenceMap( actHandler, transitionMaps )
{
	this.actHandler = actHandler;
		// If action are present in the map, actHandler is used to
		// invoke the action
		
	this.maps = transitionMaps;
	this.mapCnt = (transitionMaps) ? transitionMaps.length : 0;
}

//-----------------------------------------------------------------------------
function _zSequenceMapFirst( pageName )
{
	return ( this.mapCnt > 0 ) ? this.maps[0].pageName : kUnknownID;
}

//-----------------------------------------------------------------------------
function _zSequenceMapFindMap( pageName )
{
	var map = null;

	for ( var i=0; i<this.mapCnt; i++ )
	{
		if ( this.maps[i].pageName == pageName )
		{
			map = this.maps[i];
			break;
		}
	}
	
	return map;
}

//-----------------------------------------------------------------------------
function _zSequenceMapNext( pageName, choiceID )
{
	var nextPage = kUnknownID;

	var map = this.findMap( pageName );
	if ( map )
	{
		nextPage = map.next( choiceID );
		if ( !nextPage ) nextPage = kUnknownID;
	}
		
	return nextPage;
}

//-----------------------------------------------------------------------------
function _zSequenceMapNextAct( pageName, choiceID )
{
	var nextAct = kUnknownID;

	var map = this.findMap( pageName );
	if ( map )
	{
		nextAct = map.nextAct( choiceID );
		if ( !nextAct ) nextAct = kUnknownID;
	}
		
	return nextAct;
}


//-----------------------------------------------------------------------------------------------
function _zSequenceRunToNext( curItem, response )
	// Run the next item in the specified sequence map based on the specified
	// current item and response.
{
	if(!response) response="next";
	
	var nextItem = kUnknownID;
	if( curItem ) nextItem = this._runToNext(curItem,response);
	else nextItem = this.first();
	
	return nextItem;
}

//-----------------------------------------------------------------------------------------------
function _zSequenceRunToNextImpl( curItem, response )
	// Determine what to to do next
{	
	var nextItem = kUnknownID;
	
	// If the next item is an action, invoke the action using the actHandler callback.
	var action = this.nextAct( curItem, response );
	if ( action != kUnknownID )
	{
		if( this.actHandler )
		{
			var actToRun = null;
			
			// Strip any query string parameters
			var pos = action.indexOf('?');
			if( pos < 0 ) actToRun = action;
			else actToRun = action.substr( 0, pos );
			
			// Run the action
			var result = this.actHandler(actToRun);
			
			// Recursively determine the next item base on the action result
			nextItem = this._runToNext( action, result );
		}	
	}
	else
	{
		// Determine the next item
		nextItem = this.next( curItem, response );
	}	
	
	return nextItem;
}

//-----------------------------------------------------------------------------
p = zSequenceMap.prototype;
p.first = _zSequenceMapFirst;
p.next = _zSequenceMapNext; //(pageName, choiceID)
p.nextAct = _zSequenceMapNextAct; //(pageName, choiceID)
p.findMap = _zSequenceMapFindMap; //(pageName)
p.runToNext = _zSequenceRunToNext; //(curItem, response)
p._runToNext = _zSequenceRunToNextImpl; //(curItem, response)
p = null;


//-----------------------------------------------------------------------------
// zTransitionMap - encapsulates the transition map for a dialog
//-----------------------------------------------------------------------------
function zTransitionMap( pageName, transitionMapItems )
{
	this.pageName = pageName;
	this.items = transitionMapItems;
	this.itemCnt = (transitionMapItems) ? transitionMapItems.length : 0;
}

//-----------------------------------------------------------------------------
function _zTransitionMapFind( choiceID )
	// Returns the next page ID based on the choice
{
	var item = null;
	
	for ( var i=0; i<this.itemCnt; i++ )
	{
		if ( this.items[i].choiceID == choiceID )
		{
			item = this.items[i];
			break;
		}		
	}
	
	return item;
}

//-----------------------------------------------------------------------------
function _zTransitionMapNextAct( choiceID )
	// Returns the next page ID based on the choice
{
	var item = this.find( choiceID );
	return ( ( item && item.action ) ? item.action : kUnknownID );
}

//-----------------------------------------------------------------------------
function _zTransitionMapNext( choiceID )
	// Returns the next page ID based on the choice
{
	var item = this.find( choiceID );	
	return ( ( item && item.pageName ) ? item.pageName : kUnknownID );
}

//-----------------------------------------------------------------------------
p = zTransitionMap.prototype;
p.nextAct = _zTransitionMapNextAct; //(choiceID)
p.next = _zTransitionMapNext; //(choiceID)
p.find = _zTransitionMapFind; //(choiceID)
p = null;


//-----------------------------------------------------------------------------
// zTransitionMapItem - encapsulates the transition map for a dialog
//-----------------------------------------------------------------------------
function zTransitionMapItem( choiceID, pageName, action )
{
	this.choiceID = choiceID;
	if ( pageName ) this.pageName = pageName;
	if ( action ) this.action = action;
}

//-----------------------------------------------------------------------------
p = zTransitionMapItem.prototype;
p.pageName = null;
p.action = null;
p = null;
